/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.configuration;

import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.utils.NetworkUtils;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"file:${DEFAULT_PROPERTIES}"})
public class SQLoaderConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SQLoaderConfiguration.class);
    @Value(value="${project.version:unknown}")
    public String projectVersion;
    @Value(value="${sqream.version:unknown}")
    private String sqreamJdbcVersion;
    @Value(value="${oracle.version:unknown}")
    private String oracleJdbcVersion;
    @Value(value="${postgres.version:unknown}")
    private String postgresJdbcVersion;
    @Value(value="${mssql.version:unknown}")
    private String mssqlJdbcVersion;
    @Value(value="${sap.version:unknown}")
    private String sapJdbcVersion;
    @Value(value="${teradata.version:unknown}")
    private String teradataJdbcVersion;
    @Value(value="${sybase.version:unknown}")
    private String sybaseJdbcVersion;
    @Value(value="${configFile:#{null}}")
    public String configFile;
    @Value(value="${configDir:config/}")
    public String configDir;
    @Value(value="${connectionStringSqream}")
    public String connectionStringSqream;
    @Value(value="${connectionStringSource}")
    public String connectionStringSource;
    @Value(value="${connectionStringCatalog:#{null}}")
    public String connectionStringCatalog;
    @Value(value="${cdcCatalogTable:null.null}")
    public String cdcCatalogTable;
    @Value(value="${cdcTrackingTable:null.null}")
    public String cdcTrackingTable;
    @Value(value="${cdcPrimaryKeyTable:null.null}")
    public String cdcPrimaryKeyTable;
    @Value(value="${loadSummaryTable:#{null}}")
    public String loadSummaryTable;
    @Value(value="${loadTypeName:full}")
    public String loadTypeName;
    @Value(value="${caseSensitive:#{false}}")
    public Boolean caseSensitive;
    @Value(value="${rowid:#{false}}")
    public boolean rowid;
    @Value(value="${threadCount:#{1}}")
    public int threadCount;
    @Value(value="${splitByColumn:#{null}}")
    public String splitByColumn;
    @Value(value="${chunkSize:#{0}}")
    public int chunkSize;
    @Value(value="${usePartitions:#{true}}")
    public boolean usePartitions;
    @Value(value="${limit:#{0}}")
    public int limit;
    @Value(value="${count:#{true}}")
    public boolean count;
    @Value(value="${filter:1=1}")
    public String filter;
    @Value(value="${drop:#{false}}")
    public boolean drop;
    @Value(value="${truncate:#{false}}")
    public boolean truncate;
    @Value(value="${columnListFilePath:#{null}}")
    public String columnListFilePath;
    @Value(value="${columns:#{null}}")
    public String columns;
    @Value(value="${cdcDelete:#{true}}")
    public boolean cdcDelete;
    @Value(value="${sourceDatabaseName:ORCL}")
    public String sourceDatabaseName;
    @Value(value="${sourceSchema:#{null}}")
    public String sourceSchema;
    @Value(value="${sourceTable:#{null}}")
    public String sourceTable;
    @Value(value="${sqreamSchema:#{null}}")
    public String sqreamSchema;
    @Value(value="${sqreamTable:#{null}}")
    public String sqreamTable;
    @Value(value="${lockTable:#{true}}")
    public boolean lockTable;
    @Value(value="${lockCheck:#{true}}")
    public boolean lockCheck;
    @Value(value="${loadDttm:#{true}}")
    public boolean loadDttm;
    @Value(value="${loadDttmColumnName:sq_load_dttm}")
    public String loadDttmColumnName;
    @Value(value="${useDbmsLob:#{true}}")
    public boolean useDbmsLob;
    @Value(value="${logDir:logs}")
    public String logDir;
    @Value(value="${partitionName:#{null}}")
    public String partitionName;
    @Value(value="${batchSize:#{10000}}")
    public Integer batchSize;
    @Value(value="${fetchSize:#{100000}}")
    public int fetchSize;
    @Value(value="${checkCdcChain:#{false}}")
    public boolean checkCdcChain;
    @Value(value="${validateSourceTable:#{true}}")
    public boolean validateSourceTable;
    @Value(value="${typeMappingFileName}")
    public String typeMappingFileName;
    @Value(value="${typeMappingPath:#{null}}")
    public String typeMappingPath;
    @Value(value="${reservedWordFileName}")
    public String reservedWordFileName;
    @Value(value="${reservedWordPath:#{null}}")
    public String reservedWordPath;
    @Value(value="${clustered:#{true}}")
    public Boolean clustered;
    public String requestedHost;
    @Value(value="${server.port}")
    String port;
    @Value(value="${warnOnIncLoadFilterChanges:#{true}}")
    public boolean warnOnIncLoadFilterChanges;
    @Value(value="${autoCreateNewNullableColumn:#{false}}")
    public boolean autoCreateNewNullableColumn;

    @PostConstruct
    public void init() throws Exception {
        this.setHost();
    }

    private void setHost() {
        this.requestedHost = NetworkUtils.getHostIp() + ":" + this.port;
    }

    @Bean
    public Params getParams() {
        return Params.builder().build();
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public String getSqreamJdbcVersion() {
        return this.sqreamJdbcVersion;
    }

    public String getOracleJdbcVersion() {
        return this.oracleJdbcVersion;
    }

    public String getPostgresJdbcVersion() {
        return this.postgresJdbcVersion;
    }

    public String getMssqlJdbcVersion() {
        return this.mssqlJdbcVersion;
    }

    public String getSapJdbcVersion() {
        return this.sapJdbcVersion;
    }

    public String getTeradataJdbcVersion() {
        return this.teradataJdbcVersion;
    }

    public String getSybaseJdbcVersion() {
        return this.sybaseJdbcVersion;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public String getConnectionStringSqream() {
        return this.connectionStringSqream;
    }

    public String getConnectionStringSource() {
        return this.connectionStringSource;
    }

    public String getConnectionStringCatalog() {
        return this.connectionStringCatalog;
    }

    public String getCdcCatalogTable() {
        return this.cdcCatalogTable;
    }

    public String getCdcTrackingTable() {
        return this.cdcTrackingTable;
    }

    public String getCdcPrimaryKeyTable() {
        return this.cdcPrimaryKeyTable;
    }

    public String getLoadSummaryTable() {
        return this.loadSummaryTable;
    }

    public String getLoadTypeName() {
        return this.loadTypeName;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRowid() {
        return this.rowid;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public String getSplitByColumn() {
        return this.splitByColumn;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public boolean isUsePartitions() {
        return this.usePartitions;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isCount() {
        return this.count;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public String getColumnListFilePath() {
        return this.columnListFilePath;
    }

    public String getColumns() {
        return this.columns;
    }

    public boolean isCdcDelete() {
        return this.cdcDelete;
    }

    public String getSourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String getSourceSchema() {
        return this.sourceSchema;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getSqreamSchema() {
        return this.sqreamSchema;
    }

    public String getSqreamTable() {
        return this.sqreamTable;
    }

    public boolean isLockTable() {
        return this.lockTable;
    }

    public boolean isLockCheck() {
        return this.lockCheck;
    }

    public boolean isLoadDttm() {
        return this.loadDttm;
    }

    public String getLoadDttmColumnName() {
        return this.loadDttmColumnName;
    }

    public boolean isUseDbmsLob() {
        return this.useDbmsLob;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isCheckCdcChain() {
        return this.checkCdcChain;
    }

    public boolean isValidateSourceTable() {
        return this.validateSourceTable;
    }

    public String getTypeMappingFileName() {
        return this.typeMappingFileName;
    }

    public String getTypeMappingPath() {
        return this.typeMappingPath;
    }

    public String getReservedWordFileName() {
        return this.reservedWordFileName;
    }

    public String getReservedWordPath() {
        return this.reservedWordPath;
    }

    public Boolean getClustered() {
        return this.clustered;
    }

    public String getRequestedHost() {
        return this.requestedHost;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isWarnOnIncLoadFilterChanges() {
        return this.warnOnIncLoadFilterChanges;
    }

    public boolean isAutoCreateNewNullableColumn() {
        return this.autoCreateNewNullableColumn;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setSqreamJdbcVersion(String sqreamJdbcVersion) {
        this.sqreamJdbcVersion = sqreamJdbcVersion;
    }

    public void setOracleJdbcVersion(String oracleJdbcVersion) {
        this.oracleJdbcVersion = oracleJdbcVersion;
    }

    public void setPostgresJdbcVersion(String postgresJdbcVersion) {
        this.postgresJdbcVersion = postgresJdbcVersion;
    }

    public void setMssqlJdbcVersion(String mssqlJdbcVersion) {
        this.mssqlJdbcVersion = mssqlJdbcVersion;
    }

    public void setSapJdbcVersion(String sapJdbcVersion) {
        this.sapJdbcVersion = sapJdbcVersion;
    }

    public void setTeradataJdbcVersion(String teradataJdbcVersion) {
        this.teradataJdbcVersion = teradataJdbcVersion;
    }

    public void setSybaseJdbcVersion(String sybaseJdbcVersion) {
        this.sybaseJdbcVersion = sybaseJdbcVersion;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public void setConnectionStringSqream(String connectionStringSqream) {
        this.connectionStringSqream = connectionStringSqream;
    }

    public void setConnectionStringSource(String connectionStringSource) {
        this.connectionStringSource = connectionStringSource;
    }

    public void setConnectionStringCatalog(String connectionStringCatalog) {
        this.connectionStringCatalog = connectionStringCatalog;
    }

    public void setCdcCatalogTable(String cdcCatalogTable) {
        this.cdcCatalogTable = cdcCatalogTable;
    }

    public void setCdcTrackingTable(String cdcTrackingTable) {
        this.cdcTrackingTable = cdcTrackingTable;
    }

    public void setCdcPrimaryKeyTable(String cdcPrimaryKeyTable) {
        this.cdcPrimaryKeyTable = cdcPrimaryKeyTable;
    }

    public void setLoadSummaryTable(String loadSummaryTable) {
        this.loadSummaryTable = loadSummaryTable;
    }

    public void setLoadTypeName(String loadTypeName) {
        this.loadTypeName = loadTypeName;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setRowid(boolean rowid) {
        this.rowid = rowid;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setSplitByColumn(String splitByColumn) {
        this.splitByColumn = splitByColumn;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setUsePartitions(boolean usePartitions) {
        this.usePartitions = usePartitions;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setCount(boolean count) {
        this.count = count;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public void setColumnListFilePath(String columnListFilePath) {
        this.columnListFilePath = columnListFilePath;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setCdcDelete(boolean cdcDelete) {
        this.cdcDelete = cdcDelete;
    }

    public void setSourceDatabaseName(String sourceDatabaseName) {
        this.sourceDatabaseName = sourceDatabaseName;
    }

    public void setSourceSchema(String sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public void setSqreamSchema(String sqreamSchema) {
        this.sqreamSchema = sqreamSchema;
    }

    public void setSqreamTable(String sqreamTable) {
        this.sqreamTable = sqreamTable;
    }

    public void setLockTable(boolean lockTable) {
        this.lockTable = lockTable;
    }

    public void setLockCheck(boolean lockCheck) {
        this.lockCheck = lockCheck;
    }

    public void setLoadDttm(boolean loadDttm) {
        this.loadDttm = loadDttm;
    }

    public void setLoadDttmColumnName(String loadDttmColumnName) {
        this.loadDttmColumnName = loadDttmColumnName;
    }

    public void setUseDbmsLob(boolean useDbmsLob) {
        this.useDbmsLob = useDbmsLob;
    }

    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setCheckCdcChain(boolean checkCdcChain) {
        this.checkCdcChain = checkCdcChain;
    }

    public void setValidateSourceTable(boolean validateSourceTable) {
        this.validateSourceTable = validateSourceTable;
    }

    public void setTypeMappingFileName(String typeMappingFileName) {
        this.typeMappingFileName = typeMappingFileName;
    }

    public void setTypeMappingPath(String typeMappingPath) {
        this.typeMappingPath = typeMappingPath;
    }

    public void setReservedWordFileName(String reservedWordFileName) {
        this.reservedWordFileName = reservedWordFileName;
    }

    public void setReservedWordPath(String reservedWordPath) {
        this.reservedWordPath = reservedWordPath;
    }

    public void setClustered(Boolean clustered) {
        this.clustered = clustered;
    }

    public void setRequestedHost(String requestedHost) {
        this.requestedHost = requestedHost;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setWarnOnIncLoadFilterChanges(boolean warnOnIncLoadFilterChanges) {
        this.warnOnIncLoadFilterChanges = warnOnIncLoadFilterChanges;
    }

    public void setAutoCreateNewNullableColumn(boolean autoCreateNewNullableColumn) {
        this.autoCreateNewNullableColumn = autoCreateNewNullableColumn;
    }
}

