/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class BeanUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);
    @Autowired
    private ConfigurableBeanFactory beanFactory;
    private static ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static <T> T getBean(Class<T> beanClass) {
        if (context == null) {
            return null;
        }
        return (T)context.getBean(beanClass);
    }

    public void addBean(String beanName, Object beanToAdd) {
        this.beanFactory.registerSingleton(beanName, beanToAdd);
    }

    public ApplicationContext getContext() {
        return context;
    }
}

