/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService;

import com.google.common.hash.Hashing;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloader.common.enums.LoadType;
import com.sqream.sqloader.common.utils.DbUtils;
import com.sqream.sqloaderService.configuration.ReloadableProperties;
import com.sqream.sqloaderService.configuration.SQLoaderConfiguration;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.exceptions.InvalidArgumentException;
import com.sqream.sqloaderService.typemapping.CustomTypeMapping;
import com.sqream.sqloaderService.typemapping.TypeMappingPostConstruct;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.FileUtils;
import com.sqream.sqloaderService.utils.StrUtils;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ParamsValidation {
    private static final Logger log = LoggerFactory.getLogger(ParamsValidation.class);
    @Autowired
    private FileUtils fileUtils;
    @Autowired
    private TypeMappingService typeMappingService;
    @Autowired
    private SQLoaderConfiguration sqLoaderConfiguration;
    @Autowired
    private StrUtils strUtils;

    public void setAndValidateParams(Params params) throws IOException, ConfigurationException {
        this.overrideConfig(params);
        this.setBeforeValidation(params);
        this.valuesValidation(params);
        this.setAfterValidation(params);
    }

    private void overrideConfig(Params params) throws IOException, ConfigurationException {
        boolean isDefaultConfig = params.getConfigFile() != null;
        ReloadableProperties reloadableProperties = null;
        if (isDefaultConfig) {
            log.info("Got config property from {}", (Object)params.getConfigFile());
            PropertiesConfiguration configuration = new PropertiesConfiguration(new File(params.getConfigFile()));
            reloadableProperties = new ReloadableProperties(configuration, this.sqLoaderConfiguration);
        }
        BeanWrapperImpl requestWrapper = new BeanWrapperImpl((Object)params);
        BeanWrapperImpl defaultWrapper = new BeanWrapperImpl((Object)this.sqLoaderConfiguration);
        for (PropertyDescriptor propertyDescriptor : defaultWrapper.getPropertyDescriptors()) {
            String propertyNameAnnotation;
            String propertyName = propertyDescriptor.getName();
            if (!requestWrapper.isReadableProperty(propertyName) || !defaultWrapper.isReadableProperty(propertyName) || !defaultWrapper.isWritableProperty(propertyName) || !requestWrapper.isWritableProperty(propertyName)) continue;
            Object configValue = defaultWrapper.getPropertyValue(propertyName);
            if (isDefaultConfig && reloadableProperties.containsKey((Object)(propertyNameAnnotation = this.getPropertyNameByValueAnnotation(propertyName)))) {
                log.info("get property {} from outside configuration", (Object)propertyName);
                String value = reloadableProperties.getProperty(propertyNameAnnotation);
                configValue = this.castValue(value, configValue);
            }
            Object dtoValue = requestWrapper.getPropertyValue(propertyName);
            this.verifyMapping(params, dtoValue, propertyName);
            if (dtoValue != null) continue;
            requestWrapper.setPropertyValue(propertyName, configValue);
        }
    }

    private void verifyMapping(Params params, Object dtoValue, String propertyName) throws IOException {
        if (propertyName.equals("typeMappingPath")) {
            if (dtoValue != null) {
                params.setTypeMapping((TypeMappingService)new CustomTypeMapping(dtoValue.toString()));
            } else {
                this.typeMappingService.setDbTypeMappingMap(TypeMappingPostConstruct.getDbTypeMappingMap());
                params.setTypeMapping(this.typeMappingService);
            }
        }
    }

    private void setDbTypes(Params params) {
        params.setSourceDbType(DbUtils.getDbType((String)params.getConnectionStringSource()));
        params.setCatalogDbType(DbUtils.getDbType((String)params.getConnectionStringCatalog()));
    }

    private void setSqreamDatabaseName(Params params) {
        params.setSqreamDatabaseName(this.strUtils.getSqreamDatabaseName(params.getConnectionStringSqream()));
    }

    private void valuesValidation(Params params) {
        if (params.getThreadCount() < 1) {
            throw new InvalidArgumentException("threadCount must be bigger than 0. Thread count is " + params.getThreadCount(), params);
        }
        if (params.getSourceSchema() == null) {
            throw new InvalidArgumentException("You have to define source schema name", params);
        }
        if (params.getSourceTable() == null) {
            throw new InvalidArgumentException("You have to define source table name", params);
        }
        if (params.getDrop().booleanValue() && params.getLoadType() != LoadType.FULL) {
            log.warn("You cannot drop SQream table during cdc/incremental loads! Target table will not be dropped");
            params.setDrop(Boolean.valueOf(false));
        }
        if (params.getSourceDbType() == DBType.ORCL && params.getChunkSize() > 0 && (params.getSplitByColumn() == null || params.getSplitByColumn().isEmpty())) {
            throw new InvalidArgumentException("A column name is defined to split source table to the chunks per each select&load!", params);
        }
        if (params.getSourceDbType() != DBType.ORCL && params.getSourceDbType() != DBType.SQREAM && params.getThreadCount() > 1 && (params.getSplitByColumn() == null || params.getSplitByColumn().isEmpty())) {
            throw new InvalidArgumentException("A column should be defined to split the table for multi thread loads!", params);
        }
        if (params.getSourceDbType() != DBType.ORCL && params.getThreadCount() > 1 && !params.getCount().booleanValue()) {
            throw new InvalidArgumentException("Can't use thread count bigger than 1 when 'count' param is false", params);
        }
        if (params.getSqreamDatabaseName() == null || params.getSqreamDatabaseName().isEmpty()) {
            throw new InvalidArgumentException("Failed to retrieve the SQream database name from the provided connection string. Please verify the SQream connection string", ExitCode.DB_CONNECTION_ERROR, params);
        }
        if (params.getCdcPrimaryKeyTable() == null || StringUtils.countMatches((CharSequence)params.getCdcPrimaryKeyTable(), (char)'.') != 1) {
            throw new InvalidArgumentException("Catalog primary key table must be defined using format SCHEMA_NAME.TABLE_NAME", params);
        }
        if (params.getCdcCatalogTable() == null || StringUtils.countMatches((CharSequence)params.getCdcCatalogTable(), (char)'.') != 1) {
            throw new InvalidArgumentException("Catalog CDC table must be defined using format SCHEMA_NAME.TABLE_NAME", params);
        }
        if (params.getCdcTrackingTable() == null || StringUtils.countMatches((CharSequence)params.getCdcTrackingTable(), (char)'.') != 1) {
            throw new InvalidArgumentException("Catalog tracking table must be defined using format SCHEMA_NAME.TABLE_NAME", params);
        }
        if (params.getLoadSummaryTable() == null || StringUtils.countMatches((CharSequence)params.getLoadSummaryTable(), (char)'.') != 1) {
            throw new InvalidArgumentException("Load summary table must be defined using format SCHEMA_NAME.TABLE_NAME", params);
        }
        if (params.getConnectionStringCatalog() == null) {
            throw new InvalidArgumentException("Invalid JDBC url for catalog database");
        }
        if (params.getConnectionStringSource() == null) {
            throw new InvalidArgumentException("Invalid JDBC url for source database");
        }
        if (params.getConnectionStringSqream() == null) {
            throw new InvalidArgumentException("Invalid JDBC url for SQreamDB");
        }
    }

    private void setBeforeValidation(Params params) {
        this.setDbTypes(params);
        this.setSqreamDatabaseName(params);
        this.setLoadType(params);
    }

    private void setAfterValidation(Params params) {
        this.setColumnsList(params);
        this.setTableNames(params);
        this.setSplitParameters(params);
        this.setHashes(params);
    }

    private void setColumnsList(Params params) {
        if (params.getSelectedColumns() != null) {
            params.setColumnList(Arrays.asList(params.getSelectedColumns().split(",")));
        } else if (params.getColumnListFilePath() != null) {
            params.setColumnList(this.fileUtils.getFileContent(params.getColumnListFilePath(), params));
        }
    }

    private void setTableNames(Params params) {
        this.setSqreamTableNames(params);
        this.setSourceTableNames(params);
    }

    private void setSqreamTableNames(Params params) {
        if (params.getSqreamTable() == null) {
            params.setSqreamTable(params.getSourceTable());
        }
        params.setSqreamTableStg(this.strUtils.formatName(params.getSqreamTable() + "_stg", DBType.SQREAM, params.getCaseSensitive().booleanValue()));
        params.setSqreamTableTemp(this.strUtils.formatName(params.getSqreamTable() + "_temp", DBType.SQREAM, params.getCaseSensitive().booleanValue()));
        params.setSqreamTableOld(this.strUtils.formatName(params.getSqreamTable() + "_old", DBType.SQREAM, params.getCaseSensitive().booleanValue()));
        params.setSqreamTable(this.strUtils.formatName(params.getSqreamTable(), DBType.SQREAM, params.getCaseSensitive().booleanValue()));
        if (params.getSqreamSchema() == null) {
            params.setSqreamSchema(this.strUtils.formatName(params.getSourceSchema(), DBType.SQREAM, params.getCaseSensitive().booleanValue()));
        }
        params.setSqreamSchema(this.strUtils.formatName(params.getSqreamSchema(), DBType.SQREAM, params.getCaseSensitive().booleanValue()));
        params.setSqreamTableNameFull(params.getSqreamSchema() + "." + params.getSqreamTable());
        params.setSqreamTableNameFullStg(params.getSqreamSchema() + "." + params.getSqreamTableStg());
        params.setSqreamTableNameFullTemp(params.getSqreamSchema() + "." + params.getSqreamTableTemp());
        params.setSqreamTableNameFullOld(params.getSqreamSchema() + "." + params.getSqreamTableOld());
    }

    private void setSourceTableNames(Params params) {
        params.setSourceSchema(this.strUtils.formatName(params.getSourceSchema(), params.getSourceDbType(), params.caseSensitive.booleanValue()));
        params.setSourceTable(this.strUtils.formatName(params.getSourceTable(), params.getSourceDbType(), params.caseSensitive.booleanValue()));
        if (params.getSourceDbType() == DBType.ORCL) {
            params.setCdcCatalogTable(params.getCdcCatalogTable().toUpperCase());
            params.setCdcTrackingTable(params.getCdcTrackingTable().toUpperCase());
            params.setCdcPrimaryKeyTable(params.getCdcPrimaryKeyTable().toUpperCase());
        }
        params.setSourceTableNameFull(params.getSourceSchema() + "." + params.getSourceTable());
    }

    private void validateCatalogLoadSupported(Params params) {
        if (!DBType.SUPPORTED_CATALOG_DB_TYPES.contains(params.getSourceDbType())) {
            log.debug("Source type is " + String.valueOf(params.getSourceDbType()) + ", setting load type to full and turning off cdc/inc parameters");
            params.setLoadType(LoadType.FULL);
            params.setRowid(Boolean.valueOf(false));
            params.setCdcDelete(Boolean.valueOf(false));
            params.setLockCheck(Boolean.valueOf(false));
            params.setLockTable(Boolean.valueOf(false));
        }
    }

    private void setLoadType(Params params) {
        switch (params.getLoadTypeName()) {
            case "full": {
                params.setLoadType(LoadType.FULL);
                break;
            }
            case "cdc": {
                params.setLoadType(LoadType.CDC);
                params.setUseDbmsLob(Boolean.valueOf(false));
                break;
            }
            case "incremental": 
            case "inc": {
                params.setLoadType(LoadType.INC);
                params.setUseDbmsLob(Boolean.valueOf(false));
                break;
            }
            default: {
                throw new InvalidArgumentException("Unrecognized load type:" + params.getLoadTypeName(), params);
            }
        }
        this.validateCatalogLoadSupported(params);
    }

    private String getPropertyNameByValueAnnotation(String propertyName) {
        try {
            Annotation[] annotations;
            Field field = this.sqLoaderConfiguration.getClass().getField(propertyName);
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!(annotation instanceof Value)) continue;
                Value value = (Value)annotation;
                String valueName = value.value();
                int startIndex = valueName.indexOf("{");
                int stopIndex = valueName.indexOf("}");
                if (valueName.contains(":")) {
                    stopIndex = valueName.indexOf(":");
                }
                return valueName.substring(startIndex + 1, stopIndex);
            }
        }
        catch (NoSuchFieldException e) {
            log.debug("Not found field for {}", (Object)propertyName);
            return "";
        }
        log.debug("There is no annotation Value for field {}", (Object)propertyName);
        return "";
    }

    private Object castValue(String value, Object defaultValue) {
        if (defaultValue instanceof Integer) {
            return Integer.parseInt(value);
        }
        if (defaultValue instanceof Double) {
            return Double.valueOf(value);
        }
        if (defaultValue instanceof Float) {
            return Float.valueOf(value);
        }
        if (defaultValue instanceof Boolean) {
            return Boolean.valueOf(value);
        }
        if (defaultValue instanceof Long) {
            return Long.valueOf(value);
        }
        if (defaultValue instanceof String) {
            return value;
        }
        throw new RuntimeException("Not find casting for " + String.valueOf(defaultValue));
    }

    public void validateDirectory(String dir) {
        File fileDirectory = new File(dir);
        if (fileDirectory.exists()) {
            if (!(fileDirectory.canRead() && fileDirectory.canWrite() && Files.isWritable(fileDirectory.toPath()))) {
                throw new InvalidArgumentException("You don't have right write permissions to the given directory: " + dir);
            }
        } else {
            throw new InvalidArgumentException("Given directory <" + dir + "> doesn't exist");
        }
    }

    private void setSplitParameters(Params params) {
        if (params.getPartitionName() != null) {
            if (!params.getUsePartitions().booleanValue()) {
                log.warn("Partition name is specified while usePartition parameter is false! usePartition parameter will be changed to true");
            }
            params.setUsePartitions(Boolean.valueOf(true));
        }
        if (params.getThreadCount() > 1 && params.getPartitionName() != null) {
            log.warn("You cannot use multi thread option with partition parameter! Thread count will be changed to 1");
            params.setThreadCount(Integer.valueOf(1));
        }
        if (params.getSourceDbType() != DBType.ORCL && params.getRowid().booleanValue()) {
            log.warn("rowid parameter is supported only for Oracle database. changing rowid to false");
            params.setRowid(Boolean.valueOf(false));
        }
    }

    private void setHashes(Params params) {
        String requestHash = Hashing.sha256().hashString((CharSequence)params.toString(), StandardCharsets.UTF_8).toString();
        String sqreamRequestHash = Hashing.sha256().hashString((CharSequence)(params.getSqreamTableNameFull() + params.getConnectionStringSqream() + String.valueOf(params.getLoadType())), StandardCharsets.UTF_8).toString();
        params.setRequestHash(requestHash);
        params.setSqreamRequestHash(sqreamRequestHash);
    }
}

